' Copyright (C) 1997-20001 Agilent Technologies
' VXIplug&play Instrument Driver for the Agilent E1460


'/*=============================*/
'/*           HPE1460           */
'/*=============================*/
'/* Framework Revision: WIN95 4.0 */
'/*                     WINNT 4.0 */
'/* Driver Revision:    A.02.08   */
'/* Firmware Revision:  G.09.00   */
'/*=============================*/

'/*=============================*/
'/* Source Files:               */
'/*=============================*/
'/*   hpe1460.c                 */
'/*   hpe1460.h                 */
'/*=============================*/

'/*=============================*/
'/* WIN Framework Files         */
'/*=============================*/
'/*   hpe1460.def               */
'/*   hpe1460.rc                */
'/*   hpe1460.bas               */
'/*=============================*/

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

'  Returned error status values
'  Common Error numbers start at BFFC0D00

Global Const hpe1460_INSTR_ERROR_NOT_VXI                      = &HBFFC0D00&
' D01 unused
Global Const hpe1460_INSTR_ERROR_NULL_PTR                     = &HBFFC0D02&
Global Const hpe1460_INSTR_ERROR_RESET_FAILED                 = &HBFFC0D03&
Global Const hpe1460_INSTR_ERROR_UNEXPECTED                   = &HBFFC0D04&
Global Const hpe1460_INSTR_ERROR_INV_SESSION                  = &HBFFC0D05&
Global Const hpe1460_INSTR_ERROR_LOOKUP                       = &HBFFC0D06&
Global Const hpe1460_INSTR_ERROR_DETECTED                     = &HBFFC0D07&

' Used by Status System Functions
Global Const hpe1460_USER_ERROR_HANDLER                       = -1

Global Const hpe1460_ESR_OPC                                  = 601
Global Const hpe1460_ESR_QUERY_ERROR                          = 603
Global Const hpe1460_ESR_DEVICE_DEPENDENT_ERROR               = 604
Global Const hpe1460_ESR_EXECUTION_ERROR                      = 605
Global Const hpe1460_ESR_COMMAND_ERROR                        = 606

Global Const hpe1460_OPER_SCAN_DONE                           = 809

' Used by Function hpe1460_timeOut
Global Const hpe1460_TIMEOUT_MAX                              = 2147483647&
Global Const hpe1460_TIMEOUT_MIN                              = 0&


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

' required plug and play functions from VPP-3.1
Declare Function hpe1460_init Lib "hpe1460_32.dll" (ByVal InstrDesc As String, ByVal id_query As Integer, ByVal do_reset As Integer, vi As Long) As Long

Declare Function hpe1460_close Lib "hpe1460_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1460_reset Lib "hpe1460_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1460_self_test Lib "hpe1460_32.dll" (ByVal vi As Long, test_result As Integer, ByVal test_message As String) As Long

Declare Function hpe1460_error_query Lib "hpe1460_32.dll" (ByVal vi As Long, error_number As Long, ByVal error_message As String) As Long

Declare Function hpe1460_error_message Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal error_number As Long, ByVal message As String) As Long

Declare Function hpe1460_revision_query Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal driver_rev As String, ByVal instr_rev As String) As Long

' other standard functions 

Declare Function hpe1460_dcl Lib "hpe1460_32_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1460_errorQueryDetect Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal errorQueryDetect As Integer) As Long

Declare Function hpe1460_errorQueryDetect_Q Lib "hpe1460_32.dll" (ByVal vi As Long, pErrDetect As Integer) As Long

Declare Function hpe1460_opc Lib "hpe1460_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1460_opc_Q Lib "hpe1460_32.dll" (ByVal vi As Long, opc As Integer) As Long

Declare Function hpe1460_readStatusByte_Q Lib "hpe1460_32.dll" (ByVal vi As Long, statusByte As Integer) As Long

Declare Function hpe1460_statCond_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal happening As Long, pCondition As Integer) As Long

Declare Function hpe1460_statEvenClr Lib "hpe1460_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1460_statEven_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal happening As Long, pEvent As Integer) As Long

Declare Function hpe1460_timeOut Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal timeOut As Long) As Long

Declare Function hpe1460_timeOut_Q Lib "hpe1460_32.dll" (ByVal vi As Long, pTimeOut As Long) As Long

Declare Function hpe1460_trg Lib "hpe1460_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1460_wai Lib "hpe1460_32.dll" (ByVal vi As Long) As Long

'------------------------------------------------------------------------------
' Global Constants

'------------------------------------------------------------------------------

' Used by Function hpe1460_armCoun
Global Const hpe1460_ARM_COUN_MAX                         = 32767
Global Const hpe1460_ARM_COUN_MIN                         = 1

' Used by Function hpe1460_outpEcltStat_M
Global Const hpe1460_ECLTNUM_MAX                          = 1
Global Const hpe1460_ECLTNUM_MIN                          = 0

' Used by Function hpe1460_outpEcltStat_M_Q
'    hpe1460_ECLTNUM_MAX
'    hpe1460_ECLTNUM_MIN

' Used by Function hpe1460_outpTtltStat_M
Global Const hpe1460_TTLTNUM_MAX                          = 7
Global Const hpe1460_TTLTNUM_MIN                          = 0

' Used by Function hpe1460_outpTtltStat_M_Q
'    hpe1460_TTLTNUM_MAX
'    hpe1460_TTLTNUM_MIN

' Used by Function hpe1460_routClos
Global Const hpe1460_CHANNEL_MAX                          = 999999
Global Const hpe1460_CHANNEL_MIN                          = 100

' Used by Function hpe1460_routClos_Q
'    hpe1460_CHANNEL_MAX
'    hpe1460_CHANNEL_MIN

' Used by Function hpe1460_routFunc
Global Const hpe1460_CARD_MAX                             = 99
Global Const hpe1460_CARD_MIN                             = 1
Global Const hpe1460_ROUT_FUNC_WIRE1                      = 0
Global Const hpe1460_ROUT_FUNC_WIRE2                      = 1
Global Const hpe1460_ROUT_FUNC_WIRE2X64                   = 2
Global Const hpe1460_ROUT_FUNC_WIRE3                      = 3
Global Const hpe1460_ROUT_FUNC_WIRE4                      = 4

' Used by Function hpe1460_routFunc_Q
'    hpe1460_CARD_MAX
'    hpe1460_CARD_MIN
'    hpe1460_ROUT_FUNC_WIRE1
'    hpe1460_ROUT_FUNC_WIRE2
'    hpe1460_ROUT_FUNC_WIRE2X64
'    hpe1460_ROUT_FUNC_WIRE3
'    hpe1460_ROUT_FUNC_WIRE4

' Used by Function hpe1460_routOpen
'    hpe1460_CHANNEL_MAX
'    hpe1460_CHANNEL_MIN

' Used by Function hpe1460_routOpen_Q
'    hpe1460_CHANNEL_MAX
'    hpe1460_CHANNEL_MIN

' Used by Function hpe1460_routScanMode
Global Const hpe1460_ROUT_SCAN_MODE_NONE                  = 0
Global Const hpe1460_ROUT_SCAN_MODE_FRES                  = 1
Global Const hpe1460_ROUT_SCAN_MODE_RES                   = 2
Global Const hpe1460_ROUT_SCAN_MODE_VOLT                  = 3

' Used by Function hpe1460_routScanMode_Q
'    hpe1460_ROUT_SCAN_MODE_NONE
'    hpe1460_ROUT_SCAN_MODE_FRES
'    hpe1460_ROUT_SCAN_MODE_RES
'    hpe1460_ROUT_SCAN_MODE_VOLT

' Used by Function hpe1460_routScanPort
Global Const hpe1460_ROUT_SCAN_PORT_NONE                  = 0
Global Const hpe1460_ROUT_SCAN_PORT_ABUS                  = 1

' Used by Function hpe1460_routScanPort_Q
'    hpe1460_ROUT_SCAN_PORT_NONE
'    hpe1460_ROUT_SCAN_PORT_ABUS

' Used by Function hpe1460_setAll1Wire
'    hpe1460_CARD_MAX
'    hpe1460_CARD_MIN
Global Const hpe1460_BANK_7                               = 7
Global Const hpe1460_BANK_NONE                            = -1
'    hpe1460_BANK_7
Global Const hpe1460_BANK_6                               = 6
Global Const hpe1460_BANK_5                               = 5
Global Const hpe1460_BANK_4                               = 4
Global Const hpe1460_BANK_3                               = 3
Global Const hpe1460_BANK_2                               = 2
Global Const hpe1460_BANK_1                               = 1
Global Const hpe1460_BANK_0                               = 0
'    hpe1460_BANK_NONE
Global Const hpe1460_CHAN_7                               = 7
Global Const hpe1460_CHAN_NONE                            = -1
'    hpe1460_CHAN_7
Global Const hpe1460_CHAN_6                               = 6
Global Const hpe1460_CHAN_5                               = 5
Global Const hpe1460_CHAN_4                               = 4
Global Const hpe1460_CHAN_3                               = 3
Global Const hpe1460_CHAN_2                               = 2
Global Const hpe1460_CHAN_1                               = 1
Global Const hpe1460_CHAN_0                               = 0
'    hpe1460_CHAN_NONE
Global Const hpe1460_HIGH                                 = 1
Global Const hpe1460_LOW                                  = 0
'    hpe1460_HIGH
'    hpe1460_LOW
Global Const hpe1460_CLOSE_CHAN                           = 1
Global Const hpe1460_OPEN_CHAN                            = 0
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN

' Used by Function hpe1460_setAll2Wire
'    hpe1460_CARD_MAX
'    hpe1460_CARD_MIN
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN

' Used by Function hpe1460_setAll4Wire
'    hpe1460_CARD_MAX
'    hpe1460_CARD_MIN
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CHAN_7
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_NONE
'    hpe1460_CHAN_0
'    hpe1460_CHAN_1
'    hpe1460_CHAN_2
'    hpe1460_CHAN_3
'    hpe1460_CHAN_4
'    hpe1460_CHAN_5
'    hpe1460_CHAN_6
'    hpe1460_CHAN_7
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN
'    hpe1460_CLOSE_CHAN
'    hpe1460_OPEN_CHAN

' Used by Function hpe1460_systCdes_Q
'    hpe1460_CARD_MAX
'    hpe1460_CARD_MIN

' Used by Function hpe1460_systCpon
'    hpe1460_CARD_MAX
'    hpe1460_CARD_MIN

' Used by Function hpe1460_systCtyp_Q
'    hpe1460_CARD_MAX
'    hpe1460_CARD_MIN

' Used by Function hpe1460_trigSour
Global Const hpe1460_TRIG_SOUR_BUS                        = 0
Global Const hpe1460_TRIG_SOUR_ECLT0                      = 1
Global Const hpe1460_TRIG_SOUR_ECLT1                      = 2
Global Const hpe1460_TRIG_SOUR_HOLD                       = 3
Global Const hpe1460_TRIG_SOUR_IMM                        = 4
Global Const hpe1460_TRIG_SOUR_TTLT0                      = 5
Global Const hpe1460_TRIG_SOUR_TTLT1                      = 6
Global Const hpe1460_TRIG_SOUR_TTLT2                      = 7
Global Const hpe1460_TRIG_SOUR_TTLT3                      = 8
Global Const hpe1460_TRIG_SOUR_TTLT4                      = 9
Global Const hpe1460_TRIG_SOUR_TTLT5                      = 10
Global Const hpe1460_TRIG_SOUR_TTLT6                      = 11
Global Const hpe1460_TRIG_SOUR_TTLT7                      = 12
Global Const hpe1460_TRIG_SOUR_EXT                        = 13

' Used by Function hpe1460_trigSour_Q
'    hpe1460_TRIG_SOUR_BUS
'    hpe1460_TRIG_SOUR_ECLT0
'    hpe1460_TRIG_SOUR_ECLT1
'    hpe1460_TRIG_SOUR_HOLD
'    hpe1460_TRIG_SOUR_IMM
'    hpe1460_TRIG_SOUR_TTLT0
'    hpe1460_TRIG_SOUR_TTLT1
'    hpe1460_TRIG_SOUR_TTLT2
'    hpe1460_TRIG_SOUR_TTLT3
'    hpe1460_TRIG_SOUR_TTLT4
'    hpe1460_TRIG_SOUR_TTLT5
'    hpe1460_TRIG_SOUR_TTLT6
'    hpe1460_TRIG_SOUR_TTLT7
'    hpe1460_TRIG_SOUR_EXT


'------------------------------------------------------------------------------
' Function Declarations
'------------------------------------------------------------------------------

Declare Function hpe1460_abor Lib "hpe1460_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1460_armCoun Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal armCoun As Integer) As Long

Declare Function hpe1460_armCoun_Q Lib "hpe1460_32.dll" (ByVal vi As Long, armCoun As Integer) As Long

Declare Function hpe1460_initCont Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal initCont As Integer) As Long

Declare Function hpe1460_initCont_Q Lib "hpe1460_32.dll" (ByVal vi As Long, initCont As Integer) As Long

Declare Function hpe1460_initImm Lib "hpe1460_32.dll" (ByVal vi As Long) As Long

Declare Function hpe1460_outpEcltStat_M Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal ecltNum As Integer, ByVal outpEcltStat As Integer) As Long

Declare Function hpe1460_outpEcltStat_M_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal ecltNum As Integer, outpEcltStat As Integer) As Long

Declare Function hpe1460_outpStat Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal outpStat As Integer) As Long

Declare Function hpe1460_outpStat_Q Lib "hpe1460_32.dll" (ByVal vi As Long, outpStat As Integer) As Long

Declare Function hpe1460_outpTtltStat_M Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal ttltNum As Integer, ByVal outpTtltStat As Integer) As Long

Declare Function hpe1460_outpTtltStat_M_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal ttltNum As Integer, outpTtltStat As Integer) As Long

Declare Function hpe1460_routClos Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function hpe1460_routClosList Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function hpe1460_routClosList_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal channelList As String, ByVal routClosList As String) As Long

Declare Function hpe1460_routClos_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal channel As Long, routClos As Integer) As Long

Declare Function hpe1460_routFunc Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal routFunc As Integer) As Long

Declare Function hpe1460_routFunc_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal card As Integer, routFunc As Integer) As Long

Declare Function hpe1460_routOpen Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function hpe1460_routOpenList Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function hpe1460_routOpenList_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal channelList As String, ByVal routOpenList As String) As Long

Declare Function hpe1460_routOpen_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal channel As Long, routOpen As Integer) As Long

Declare Function hpe1460_routScanList Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function hpe1460_routScanMode Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal routScanMode As Integer) As Long

Declare Function hpe1460_routScanMode_Q Lib "hpe1460_32.dll" (ByVal vi As Long, routScanMode As Integer) As Long

Declare Function hpe1460_routScanPort Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal routScanPort As Integer) As Long

Declare Function hpe1460_routScanPort_Q Lib "hpe1460_32.dll" (ByVal vi As Long, routScanPort As Integer) As Long

Declare Function hpe1460_setAll1Wire Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal Card_Number As Integer, ByVal Bank As Integer, ByVal Channel As Integer, ByVal Terminal As Integer, ByVal Ch992 As Integer, ByVal Ch993 As Integer, ByVal Ch994 As Integer) As Long

Declare Function hpe1460_setAll2Wire Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal Card_Number As Integer, ByVal Bank0 As Integer, ByVal Bank1 As Integer, ByVal Bank2 As Integer, ByVal Bank3 As Integer, ByVal Bank4 As Integer, ByVal Bank5 As Integer, ByVal Bank6 As Integer, ByVal Bank7 As Integer, ByVal Ch990 As Integer, ByVal Ch991 As Integer, ByVal Ch992 As Integer, ByVal Ch993 As Integer, ByVal Ch994 As Integer, ByVal Ch995 As Integer, ByVal Ch996 As Integer) As Long

Declare Function hpe1460_setAll4Wire Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal Card_Number As Integer, ByVal Bank0 As Integer, ByVal Bank1 As Integer, ByVal Bank2 As Integer, ByVal Bank3 As Integer, ByVal Ch990 As Integer, ByVal Ch991 As Integer, ByVal Ch992 As Integer, ByVal Ch993 As Integer, ByVal Ch994 As Integer, ByVal Ch995 As Integer, ByVal Ch996 As Integer) As Long

Declare Function hpe1460_systCdes_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal systCdes As String) As Long

Declare Function hpe1460_systCpon Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal card As Integer) As Long

Declare Function hpe1460_systCtyp_Q Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal systCtyp As String) As Long

Declare Function hpe1460_trigSour Lib "hpe1460_32.dll" (ByVal vi As Long, ByVal trigSour As Integer) As Long

Declare Function hpe1460_trigSour_Q Lib "hpe1460_32.dll" (ByVal vi As Long, trigSour As Integer) As Long

